﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class TriggerCollision : MonoBehaviour {

    public ColorUsed colorIndex;
    
    void Start()
    {
        
        MenagerReferences refs = GameObject.Find("Menager").GetComponent<MenagerReferences>();
        if (refs != null)
        {
            Color newColor = refs.Colors[(int)colorIndex];
            gameObject.GetComponent<SpriteRenderer>().color = newColor;
        }
    }

   
    void OnTriggerEnter2D(Collider2D other)
    { 
        if (other.gameObject.tag == "Player")
	    {
            Color playerColor = other.gameObject.GetComponent<SpriteRenderer>().color; //boja objekta sa kojim vrsi koliziju
            Color thisColor = this.gameObject.GetComponent<SpriteRenderer>().color; // trenutna boja

            if (playerColor != thisColor )
            {
                MenagerReferences refs = GameObject.Find("Menager").GetComponent<MenagerReferences>();
                if (refs != null)
                {
                    //other.gameObject.GetComponent<Animator>().SetTrigger("Death");
                    
                    refs.ShowRestartPanel();
                }
            }
	    }
    }
}
